
var p I_o I_n prod_o prod_n F_o F_n X_o X_n theta_o theta_n VA mu_1_n mu_2_n o mu_1_o mu_2_o
    Y K L C r w beta_til a u
    dp di_n di_o dq_n dq_o dy;

varexo eps_u eps_a;

parameters beta epsilon alpha xi eta psi lambda nu varphi delta s_o G_o G_n gamma
           rho_a1 rho_a2 u_var a_var
           p_ss I_o_ss I_n_ss prod_o_ss prod_n_ss F_o_ss F_n_ss X_o_ss X_n_ss
           theta_o_ss theta_n_ss VA_ss mu_1_n_ss mu_2_n_ss o_ss mu_1_o_ss mu_2_o_ss
           Y_ss K_ss L_ss C_ss r_ss w_ss beta_til_ss;


%% Loading parameters

load calibration_parameters;

set_param_value('beta',struct_param.beta);             
set_param_value('epsilon',struct_param.epsilon);
set_param_value('alpha',struct_param.alpha);      
set_param_value('xi',struct_param.xi);  
set_param_value('eta',struct_param.eta);          
set_param_value('psi',struct_param.psi);
set_param_value('lambda',struct_param.lambda);        
set_param_value('nu',struct_param.nu);  
set_param_value('varphi',struct_param.varphi); 
set_param_value('delta',struct_param.delta); 
set_param_value('gamma',struct_param.gamma); 
set_param_value('s_o',struct_param.s_o); 
set_param_value('G_o',struct_param.G_o); 
set_param_value('G_n',struct_param.G_n); 


% Exogenous laws of motion parameters
set_param_value('rho_a1',shock_param.rho_a1);
set_param_value('rho_a2',shock_param.rho_a2);
set_param_value('u_var',shock_param.u_var);
set_param_value('a_var',shock_param.a_var);

% Steady state
set_param_value('p_ss',        endo_ss.p); 
set_param_value('I_o_ss',      endo_ss.I_o); 
set_param_value('I_n_ss',      endo_ss.I_n); 
set_param_value('prod_o_ss',   endo_ss.prod_o); 
set_param_value('prod_n_ss',   endo_ss.prod_n); 
set_param_value('F_o_ss',      endo_ss.F_o); 
set_param_value('F_n_ss',      endo_ss.F_n); 
set_param_value('X_o_ss',      endo_ss.X_o); 
set_param_value('X_n_ss',      endo_ss.X_n); 
set_param_value('theta_o_ss',  endo_ss.theta_o); 
set_param_value('theta_n_ss',  endo_ss.theta_n); 
set_param_value('VA_ss',       endo_ss.VA); 
set_param_value('mu_1_n_ss',   endo_ss.mu_1_n); 
set_param_value('mu_2_n_ss',   endo_ss.mu_2_n);
set_param_value('mu_1_o_ss',   endo_ss.mu_1_o); 
set_param_value('mu_2_o_ss',   endo_ss.mu_2_o); 
set_param_value('o_ss',        endo_ss.o); 
set_param_value('Y_ss',        endo_ss.Y); 
set_param_value('K_ss',        endo_ss.K); 
set_param_value('L_ss',        endo_ss.L); 
set_param_value('C_ss',        endo_ss.C); 
set_param_value('r_ss',        endo_ss.r); 
set_param_value('w_ss',        endo_ss.w); 
set_param_value('beta_til_ss', endo_ss.beta_til); 



%% Model
model;

% World Production Block (1-5)
exp(Y) = ((1-s_o)*exp((epsilon-1)/epsilon*a)*(exp(K(-1))^(alpha)*exp(L)^(1-alpha))^((epsilon-1)/epsilon)
          +s_o*exp(o)^((epsilon-1)/epsilon))^(epsilon/(epsilon-1));
exp(p) = s_o * exp(Y)^(1/epsilon)*exp(o)^(-1/epsilon);
exp(w) = (1-alpha)*(1-s_o)*exp((epsilon-1)/epsilon*a)*exp(Y)^(1/epsilon)*
         (exp(K(-1))^(alpha)*exp(L)^(1-alpha))^(-1/epsilon)
         *exp(K(-1))^(alpha)*exp(L)^(-alpha);
exp(r) = alpha*(1-s_o)*exp((epsilon-1)/epsilon*a)*exp(Y)^(1/epsilon)*
         (exp(K(-1))^(alpha)*exp(L)^(1-alpha))^(-1/epsilon)
         *exp(K(-1))^(alpha-1)*exp(L)^(1-alpha);
exp(VA)= exp((epsilon-1)/epsilon*a)*exp(alpha*K(-1))*exp((1-alpha)*L);

% Resource constraint (6)
exp(C) + exp(K) + exp(I_n) + exp(I_o) + psi*exp(eta*theta_n(-1))*exp(F_n(-1))
 + psi*exp(eta*(theta_o(-1)-u))*exp(F_o(-1)) = (1-delta)*exp(K(-1)) + exp(Y);

% Household Block (7-9)
exp(L) = varphi^(-1/nu) * exp(w)^(1/nu);
1 = exp(beta_til(+1))*(1+exp(r(+1))-delta);
exp(beta_til) = beta * (exp(C)      -varphi*exp(L)^(1+nu)    /(1+nu))^(-gamma) /
                       (exp(C(-1))  -varphi*exp(L(-1))^(1+nu)/(1+nu))^(-gamma);


% Non-OPEC optimality conditions (10-13)

mu_1_n = exp(beta_til(+1)) * (exp(theta_n) * exp(p(+1)) 
         + (1-exp(theta_n)) * mu_1_n(+1) - psi*exp(eta*theta_n));

mu_2_n = lambda * (mu_1_n) + exp(beta_til(+1)) * (1-lambda) * (mu_2_n(+1));

xi * exp((xi-1) * I_n) * G_n^(1-xi) * mu_2_n = 1;

eta * psi * exp((eta-1)*theta_n)*exp(beta_til(+1)) = exp(beta_til(+1))*(exp(p(+1)) - mu_1_n(+1));


% OPEC optimality conditions (14-17)

mu_1_o = exp(beta_til(+1)) * (exp(-u(+1)) * exp(theta_o) * exp(p(+1)) 
         + (1-exp(-u(+1))*exp(theta_o)) * mu_1_o(+1) - psi*exp(eta*(theta_o-u(+1))));

mu_2_o = lambda * (mu_1_o) + exp(beta_til(+1)) * (1-lambda) * (mu_2_o(+1));

xi * exp((xi-1) * I_o) * G_o^(1-xi) * mu_2_o = 1;

eta * psi * exp((eta-1)*theta_o)* exp(-(eta)*u(+1))*exp(beta_til(+1)) = exp(beta_til(+1))*exp(-u(+1))*(exp(p(+1)) - mu_1_o(+1));


% Laws of motion for K and X, and production (14-20)

exp(F_n) = (1-exp(theta_n(-1)))           * exp(F_n(-1)) + lambda * exp(X_n);
exp(F_o) = (1-exp(-u) * exp(theta_o(-1))) * exp(F_o(-1)) + lambda * exp(X_o);

exp(X_n) = (1-lambda) * exp(X_n(-1))  + exp(xi * I_n) * G_n^(1-xi);
exp(X_o) = (1-lambda) * exp(X_o(-1))  + exp(xi * I_o) * G_o^(1-xi);

exp(prod_n) = exp(theta_n(-1)) * exp(F_n(-1));
exp(prod_o) = exp(-u) * exp(theta_o(-1)) * exp(F_o(-1));

exp(o) = exp(prod_n) + exp(prod_o);

% Laws of motion for exogenous variables (21-22)

u =  eps_u;          
a = rho_a1 * a(-1) + rho_a2 * a(-2) + eps_a;


% log changes (24-28)
dp = p - p(-1);
di_n = I_n - I_n(-1);
di_o = I_o - I_o(-1);
dq_n = prod_n - prod_n(-1);
dq_o = prod_o - prod_o(-1);
dy = Y - Y(-1);

end;

initval;
    p           = ln(p_ss);
    I_o         = ln(I_o_ss);
    I_n         = ln(I_n_ss);
    prod_o      = ln(prod_o_ss);
    prod_n      = ln(prod_n_ss);
    F_o         = ln(F_o_ss);
    F_n         = ln(F_n_ss);
    X_o         = ln(X_o_ss);
    X_n         = ln(X_n_ss);
    theta_o     = ln(theta_o_ss);
    theta_n     = ln(theta_n_ss);
    VA          = ln(VA_ss);
    mu_1_n      = mu_1_n_ss;
    mu_2_n      = mu_2_n_ss;
    mu_1_o      = mu_1_o_ss;
    mu_2_o      = mu_2_o_ss;
    o           = ln(o_ss);
    Y           = ln(Y_ss);
    K           = ln(K_ss);
    L           = ln(L_ss);
    C           = ln(C_ss);
    r           = ln(r_ss);
    w           = ln(w_ss);
    beta_til    = ln(beta_til_ss);

    u       = 0;          
    a       = 0;
    dp      = 0;
    di_n    = 0;
    di_o    = 0;
    dq_n    = 0;
    dq_o    = 0;
    dy      = 0;

end;

steady;

check;

%% Shocks
shocks;
    var eps_u = u_var;
    var eps_a = a_var;
end;

options_.noprint = 1;

%% Simulating the Model
stoch_simul(order = 2, pruning, IRF = 0, AR = 20) dp di_n di_o dq_n dq_o dy;
